<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use Ramsey\Uuid\Uuid;
use Validator;

class CategoryController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
      //  $this->middleware('admin');
    }
    public function index()
    {
        $category = Category::paginate(10);
        return view('admin.ventures')->with(array('category'=>$category ));
       
    }

    public function createcategory()
    {
        return view('admin.createcategory');
    }

    public function store(Request $request)
    {
     //   dd($request);
        $request->validate([
            'name' => 'required|string|max:255',
        ]);
        if ($request->isMethod('post')) {

            $name =strip_tags($request->name);
            $user = new \App\Models\Category();
            $user->name = $name;
            $user->uuid = Uuid::uuid4();
            $user->save();
            return back()->with('success','Category successfully created.');

        }else{
                
            return back()->with('error','an error occurred.');
        }

      //  return Category::create($request->all());
    }

    public function show(Category $category)
    {
        return $category;
    }

    public function update(Request $request, Category $category)
    {
        $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $category->update($request->all());

        return $category;
    }

    public function destroy(Category $category)
    {
        $category->delete();

        return response(null, 204);
    }
}
