<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use Ramsey\Uuid\Uuid;
use App\Models\Product;
use App\Models\Billing;
use App\Models\ProductImages;
use App\Models\ProductRequest;
use Illuminate\Support\Facades\Storage;
use Validator;
use Auth;
use Session;
class ProductController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except('update','remove','billing','checkout','billing2','approverequest');
      //  $this->middleware('admin');
    }

    public function approverequest(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'id' =>'required|string',
        ]);
        if($validator->fails()){
            $error = $validator->errors()->first();
             return response()
            ->json(['data' =>"An error occurred, Kindly try again" ,'status' =>(bool) false, ], 200);//"An error occurred, Kindly supply the right information"
        //    return back()->with('error',$error);
        }

        $affectedRows = Billing::where('uuid','=', $request->id)->update(['payment_status'=>1]);
        //return back()->with('success','Payment status successfully updated');
        return response()
        ->json(['data' =>"Payment status successfully updated" ,'status' =>(bool) false, ], 200);
    }


    public function viewrequest($id)
    {
           
        if(isset($id)){ 
           
            $product = Billing::where('uuid','=', $id)->get();
          return view('admin.viewrequest')->with(array('product'=>$product  ));
         //   dd($product[0]->productRequest[0]->product->productImages[0]->path);
        }else{
                 return redirect()->intended('/logout');
         }
    }


    public function requests()
    {
        $offices1 = Billing::orderBy('created_at', 'DESC')->paginate(10);
    
           return view('admin.requests')->with(array('billings'=>$offices1 ));
  
    }
    public function addproduct()
    {
       
     //   if(isset($id)){ 
            $offices1 = Category::get();
          //  dd($offices1);
             return view('admin.addproduct')->with(array('category_id'=>$offices1[0]['uuid'], 'category'=>$offices1 ));
        // }else{
        //     return redirect()->intended('/logout');
        // }
    }
    public function checkout ()
    {
       
        if (\Auth::check()) { 
            return view('checkout'); 
        }else{ 
            return view('checkout2'); 
        }
    }
    
    public function billing2(Request $request)
    {//phone country address town postalcode  // firstname lastname email 
        $validator = Validator::make($request->all(),[
            'phone' => 'required|string|max:255',
            'country' => 'required|string',
            'address' => 'required|string',
            'town' => 'required|string',
            'postalcode' => 'required',
            'firstname' =>'required|string|max:255',
            'lastname' => 'required|string|max:255',
            'email' =>'required|string',
        ]);
        if($validator->fails()){
            $error = $validator->errors()->first();
            // return response()
            // ->json(['data' =>"An error occurred, Kindly supply the right information" ,'status' =>(bool) false, ], 200);//"An error occurred, Kindly supply the right information"
            return back()->with('error',$error);
        }
        $total = 0 ;

        foreach((array) session('cart') as $id => $details){

            $total += $details['price'] * $details['quantity'];
        }
        $phone =strip_tags($request->phone);
        $country =strip_tags($request->country);
        $address =strip_tags($request->address);
        $town =strip_tags($request->town);
        $postalcode =strip_tags($request->postalcode);
        $firstname =strip_tags($request->firstname);
        $lastname =strip_tags($request->lastname);
        $email =strip_tags($request->email);
        $uuid = Uuid::uuid4();
        $gg=  substr(hash('sha256', mt_rand().microtime()),0,20);
                    $projects = new Billing();  
                    $projects->uuid =$uuid;
                    $projects->firstname =$firstname;
                    $projects->lastname = $lastname  ;
                    $projects->email=$email;
                    $projects->phone=$phone;
                    $projects->country =$country;
                    $projects->address=$address;
                    $projects->town=$town;
                    $projects->postalcode=$postalcode;
                    $projects->price= $total;
                    $projects->trans_id = $gg;
                    $projects->save();

            if(session('cart')){
                foreach(session('cart') as $id => $details)  { ////uuid billing_id product_id name price quantity  

                    $project = new ProductRequest();  
                    $project->uuid =Uuid::uuid4();
                    $project->billing_id =$uuid;
                    $project->product_id = $details['id'] ;
                    $project->name=$details['name'] ;
                    $project->price=$details['price'];
                    $project->quantity =$details['quantity'];
                    $project->save();

                 }
            }
            Session::forget('cart');

            return view('order_success')->with(array('billing'=>$projects ));

    }

    public function billing(Request $request)
    {//phone country address town postalcode  // firstname lastname email 
        $validator = Validator::make($request->all(),[
            'phone' => 'required|string|max:255',
            'country' => 'required|string',
            'address' => 'required|string',
            'town' => 'required|string',
            'postalcode' => 'required',
        ]);
        if($validator->fails()){
            $error = $validator->errors()->first();
            // return response()
            // ->json(['data' =>"An error occurred, Kindly supply the right information" ,'status' =>(bool) false, ], 200);//"An error occurred, Kindly supply the right information"
            return back()->with('error',$error);
        }
        $total = 0 ;

        foreach((array) session('cart') as $id => $details){

            $total += $details['price'] * $details['quantity'];
        }
        $phone =strip_tags($request->phone);
        $country =strip_tags($request->country);
        $address =strip_tags($request->address);
        $town =strip_tags($request->town);
        $postalcode =strip_tags($request->postalcode);
        $uuid = Uuid::uuid4();
                 $gg=  substr(hash('sha256', mt_rand().microtime()),0,20);
                    $projects = new Billing();  
                    $projects->uuid =$uuid;
                    $projects->firstname =auth()->user()->name;
                    $projects->lastname = auth()->user()->lname ;
                    $projects->email=auth()->user()->email;
                    $projects->phone=$phone;
                    $projects->country =$country;
                    $projects->address=$address;
                    $projects->town=$town;
                    $projects->postalcode=$postalcode;
                    $projects->price= $total;
                    $projects->trans_id = $gg;
                    $projects->save();

       

           //  @php $total += $details['price'] * $details['quantity'] @endphp

         

            if(session('cart')){
                foreach(session('cart') as $id => $details)  { ////uuid billing_id product_id name price quantity  

                    $project = new ProductRequest();  
                    $project->uuid =Uuid::uuid4();
                    $project->billing_id =$uuid;
                    $project->product_id = $details['id'] ;
                    $project->name=$details['name'] ;
                    $project->price=$details['price'];
                    $project->quantity =$details['quantity'];
                    $project->save();

                 }
            }
            Session::forget('cart');
            return view('order_success')->with(array('billing'=>$projects ));

    }

    public function myorders()
    {
       $gmail= \Auth::user()->email;

       $product = Billing::where('email','=',\Auth::user()->email)->orderBy('created_at', 'DESC')->paginate(10);
       return view('orders')->with(array('billing'=>$product ));
    }

      public function createvproducts(Request $request)
    {   ini_set('max_execution_time', 360000);
        ini_set("upload_max_filesize","90M");

        $this->validate($request, [
            'name' => 'required|string|max:255',
            'quantity' => 'required|numeric',
            'description' => 'required|string',
            'price' => 'required|numeric',
            'category_id' => 'required',
            'images' => 'required',
        ]);

        $files = $request->file('images');
        $name =strip_tags($request->name);
        $quantity =strip_tags($request->quantity);
        $description =strip_tags($request->description);
        $price =strip_tags($request->price);
        $category_id =strip_tags($request->category_id);
        $allowedfileExtension=['jpeg','png','jpg','gif','svg'];
        $uuid = Uuid::uuid4();
        $projects = new Product();  
                    $projects->uuid =$uuid;
                    $projects->name =$name;
                    $projects->image_path = $uuid ;
                    $projects->description=$description;
                    $projects->price=$price;
                    $projects->category_id =$category_id;
                    $projects->quantity=$quantity;
                    $projects->save();
        // $filename = $file->getClientOriginalName();
        // $extension = $file->getClientOriginalExtension();
        // $check=in_array($extension,$allowedfileExtension);
        // $ext =  $file->getClientOriginalExtension();
       
        foreach($files as $file){
            $filename = $file->getClientOriginalName();
           // $file->get
            $extension = $file->getClientOriginalExtension();
            $check=in_array($extension,$allowedfileExtension);
            $ext =  $file->getClientOriginalExtension();
            if($check)
            {}
            else{
                return back()->with('error','Sorry Only Upload png , jpg , pdf');
               // Se
              // return redirect()->route('home')->with('warning','Don't Open this link);
               //return back()->with('info','You added new items, follow next step!');
               // echo '<div class="alert alert-warning"><strong>Warning!</strong> Sorry Only Upload png , jpg , pdf</div>';

            }
         }
        foreach ($_FILES["images"]["error"] as $key=>$error)
        {
               if ($error == UPLOAD_ERR_OK)
               {
                  $tmp_namea = $_FILES["images"]["tmp_name"][$key];
                  $namea=basename($_FILES["images"]["name"][$key]);
                  //'uploads/project/'.time().'_'.$name;
                  $namea = 'uploads/productimages/'.time().'_'.$namea;
                  move_uploaded_file($tmp_namea,$namea);
                  $proje = new ProductImages();    //path product_uuid  uploaded_by
                  $proje->path =$namea;
                  $proje->product_uuid = $uuid;
                  $proje->uploaded_by=\Auth::user()->uuid;
                  $proje->save();
                  return back()->with('success','Product successfully created');
              }else{
                  return back()->with('error','An error while creating product');
              }
         }


    }

    public function show()
    {
       // return $product->load('category');
       $product = Product::orderBy('created_at', 'DESC')->paginate(10);
       //dd($product->productImages());
        return view('admin.products')->with(array('product'=>$product ));
    }

    public function editproduct($id)
    {
        
        if(isset($id)){ 
            $offices1 = Category::get();
            $product = Product::where('uuid','=', $id)->get();
            return view('admin.editproduct')->with(array('product'=>$product, 'category'=>$offices1,'id'=>$id  ));

        }else{
                 return redirect()->intended('/logout');
         }

    }

    public function editvproducts(Request $request)
    { 
        ini_set('max_execution_time', 360000);
        ini_set("upload_max_filesize","90M");
        $validator = Validator::make($request->all(),[
     
            'name' => 'required|string|max:255',
            'quantity' => 'required|numeric',
            'description' => 'required|string',
            'price' => 'required|numeric',
            'category_id' => 'required',
            'id' => 'required',
        ]);
        if($validator->fails()){
            $error = $validator->errors()->first();
            // return response()
            // ->json(['data' =>"An error occurred, Kindly supply the right information" ,'status' =>(bool) false, ], 200);//"An error occurred, Kindly supply the right information"
            return back()->with('error',$error);
        }
        $name =strip_tags($request->name);
        $quantity =strip_tags($request->quantity);
        $description =strip_tags($request->description);
        $price =strip_tags($request->price);
        $category_id =strip_tags($request->category_id);
        $id =strip_tags($request->id);
        $affectedRows = Product::where('uuid','=', $id)->update(['name' =>$name,'description'=>$description, 'price'=>$price, 'category_id'=>$category_id ,'quantity'=>$quantity]);
        return back()->with('success','Product successfully updated');
    }
    public function removeproduct ($id)
    {
        if(isset($id)){ 
             $id = strip_tags($id);
             $product = Product::where('uuid','=', $id)->delete();
             return back()->with('success','Product successfully removed');

        }else{
                return redirect()->intended('/logout');
        }

    }

    public function addToCart($id)

    {//  id quantity price image

        $product = Product::where('uuid','=', $id)->get();

          

        $cart = session()->get('cart', []);

  

        if(isset($cart[$id])) {

            $cart[$id]['quantity']++;

        } else {

            $cart[$id] = [

                "name" => $product->name,

                "quantity" => 1,

                "price" => $product->price,

                "image" => $product->image

            ];

        }

          

        session()->put('cart', $cart);

        return redirect()->back()->with('success', 'Product added to cart successfully!');

    }

  

    /**

     * Write code on Method

     *

     * @return response()

     */

    public function update(Request $request)

    {

        if($request->id && $request->quantity &&  $request->price && $request->name){

            $cart = session()->get('cart');

            $cart[$request->id]["quantity"] = $request->quantity;
            $cart[$request->id]["price"] = $request->price;
            $cart[$request->id]["image"] = $request->image;
            $cart[$request->id]["id"] = $request->id;
            $cart[$request->id]["name"] = $request->name;
            session()->put('cart', $cart);

            session()->flash('success', 'Cart updated successfully');

        }

    }


    public function remove(Request $request)

    {

        if($request->id) {

            $cart = session()->get('cart');

            if(isset($cart[$request->id])) {

                unset($cart[$request->id]);

                session()->put('cart', $cart);

            }

            session()->flash('success', 'Product removed successfully');

        }

    }



    // public function update(Request $request)
    // {
    //     $request->validate([
    //         'name' => 'required|string|max:255',
    //         'description' => 'nullable|string',
    //         'price' => 'required|numeric',
    //         'category_id' => 'required|exists:categories,id',
    //         'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
    //     ]);

    //     if ($request->hasFile('image')) {
    //         Storage::disk('public')->delete($product->image_path);
    //         $imagePath = $request->file('image')->store('products', 'public');
    //         $request->merge(['image_path' => $imagePath]);
    //     }

    //     $product->update($request->all());

    //     return $product;
    // }

    // public function destroy(Product $product)
    // {
    //     Storage::disk('public')->delete($product->image_path);
    //     $product->delete();

    //     return response(null, 204);
    // }



}