<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use Ramsey\Uuid\Uuid;
use App\Models\Product;
use App\Models\ProductImages;
class WelcomeController extends Controller
{
    //


    public function welcome()
    {//orderBy('created_at', 'DESC')->paginate(10)
        $product = Product::orderBy('created_at', 'DESC')->get();
        return view('welcome')->with(array('product'=>$product ));
    } 

    public function productdetails($id)
    {
        if(isset($id)){ 

                $product = Product::where('uuid','=', $id)->get();
                return view('productdetails')->with(array('product'=>$product));
//->with(array('product'=>$product, 'category'=>$offices1,'id'=>$id  ))
        }else{
                return redirect()->intended('/logout');
        }
    }

    public function addToCart($id)

    {

        $product = Product::findOrFail($id);

          

        $cart = session()->get('cart', []);

  

        if(isset($cart[$id])) {

            $cart[$id]['quantity']++;

        } else {

            $cart[$id] = [

                "name" => $product->name,

                "quantity" => 1,

                "price" => $product->price,

                "image" => $product->image

            ];

        }

          

        session()->put('cart', $cart);

        return redirect()->back()->with('success', 'Product added to cart successfully!');

    }

  

    /**

     * Write code on Method

     *

     * @return response()

     */

    public function update(Request $request)

    {

        if($request->id && $request->quantity){

            $cart = session()->get('cart');

            $cart[$request->id]["quantity"] = $request->quantity;

            session()->put('cart', $cart);

            session()->flash('success', 'Cart updated successfully');

        }

    }

  

    /**

     * Write code on Method

     *

     * @return response()

     */

    public function remove(Request $request)

    {

        if($request->id) {

            $cart = session()->get('cart');

            if(isset($cart[$request->id])) {

                unset($cart[$request->id]);

                session()->put('cart', $cart);

            }

            session()->flash('success', 'Product removed successfully');

        }

    }


}
