<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Billing extends Model
{
    use HasFactory;
    protected $table ='billing';
    protected $fillable = ['firstname', 'lastname', 'price', 'email', 'country', 'address','uuid', 'town', 'postalcode','trans_id', 'payment_status']; //uuid firstname lastname email phone country address town postalcode  price

    public function productRequest()
    {
        return $this->hasMany('App\Models\ProductRequest', 'billing_id','uuid' );
    }

    // public function productImages()
    // {
    //     return $this->hasMany('App\Models\ProductImages', 'product_uuid','image_path' );
    // }

}
