<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;
    protected $table ='products';
    protected $fillable = ['name', 'description', 'price', 'category_id', 'quantity', 'image_path','uuid'];

     public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function productImages()
    {
        return $this->hasMany('App\Models\ProductImages', 'product_uuid','image_path' );
    }
    public function productRequest()
    {
        return $this->hasMany('App\Models\ProductRequest', 'product_id','uuid' );
    }


}
