<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductRequest extends Model
{
    use HasFactory;
    protected $table ='product_request';
    protected $fillable = ['uuid', 'billing_id', 'product_id', 'name', 'price', 'quantity' ]; //uuid billing_id product_id name price quantity
    public function billing()
    {
        return $this->belongsTo('App\Models\Billing', 'uuid','billing_id');
    }
    public function product()
    {
        return $this->belongsTo('App\Models\Product', 'product_id','uuid');
    }

}
