@extends('layouts.admin')
@section('title')

@endsection

@section('styles')
<!-- <script src="https://cloud.tinymce.com/stable/tinymce.min.js"></script>
  <script>tinymce.init({ selector:'textarea' });</script> -->
@endsection

@section('page')
<a href="{{url('/home')}}">Dashboard</a>
@endsection


@section('content')
<section class="ls section_padding_top_50 section_padding_bottom_50 columns_padding_5">
				<div class="container-fluid">

					<div class="row">
						<div class="col-sm-12">
							<h3>Edit 
								<small>Product</small>
							</h3>
						</div>
					</div>
					<!-- .row -->

					<div class="row">
						<div class="col-sm-8">
							<div class="with_border with_padding">
                                <div class="col-md-12">
                                        @if (Session::has('error'))
                                            <div class="alert alert-danger" role="alert">
                                            {{Session::get('error', 'Something went wrong. Please try again')}}
                                            </div>
                                            @elseif(Session::has('success'))
                                            <div class="alert alert-success" role="alert">
                                                {{Session::get('success')}}
                                            </div>
                                        @endif
                                    </div>





                                    <h4>
										Edit Product
										
									</h4>

									<hr>
                                    <form action="/editvproducts" method="post" enctype="multipart/form-data">
                                            {{ csrf_field() }}
											<input type="hidden" name="id" value="{{$id}}">
									<div class="row form-group">
										<label class="col-lg-3 control-label"> Name: </label>
										<div class="col-lg-9">
											<input type="text" id="name" name="name" value="{{$product[0]['name']}}" class="form-control">
										</div>
									</div>
									<div class="row form-group">
										<label class="col-lg-3 control-label"> Price: </label>
										<div class="col-lg-9">
											<input type="number" id="price" name="price" value="{{$product[0]['price']}}" min="0.00" max="1000000000.00" step="0.01" class="form-control">
										</div>
									</div>

									
									<div class="row form-group">
										<label class="col-lg-3 control-label"> Category : </label>
										<div class="col-lg-9">
										<select class="form-control" id="category_id" name="category_id"  >
											<option value="">Select Product Category</option>
												@foreach($category as $sho)
													<option value="{{$sho['uuid']}}">{{$sho['name']}}</option>
												@endforeach		
											</select>	
										</div>
									</div>
									
									<div class="row form-group">
										<label class="col-lg-3 control-label"> Description: </label>
										<div class="col-lg-9">
										<textarea class="form-control" id="description" name="description" rows="5" cols="86">{{$product[0]['description']}}</textarea>
										</div>
									</div>

									<div class="row form-group">
										<label class="col-lg-3 control-label"> Quantity: </label>
										<div class="col-lg-9">
											<input type="number" id="quantity"  value="{{$product[0]['quantity']}}" name="quantity" class="form-control">
										</div>
									</div>
									
																		

									<div class="row">
										<div class="col-sm-12 text-right">
                                        <input type="submit" class="theme_button small_button" value="Edit Product" />
											
										</div>
									</div>

                                    </form>


                            </div>
							<!-- .with_border -->

						</div>
						<!-- .col-* -->
					</div>
					<!-- .row -->


					<!-- .row -->

				</div>
				<!-- .container -->
			</section>
@endsection


@section('script')
  <script src="../js/joseadebag.js"></script>
  <script src="../js/admin/moment.min.js"></script>
  <script src="../js/admin/fullcalendar.min.js"></script>
  <script src="../js/admin/daterangepicker.js"></script>
<script>
	//  $("#category_id").hide();
</script>
@endsection