@extends('layouts.users')
@section('content')



<!--breadcrumb start-->
<section class="theme-breadcrumb">
    <nav aria-label="breadcrumb">
        <div>
            <h2 class="text-center">CHECKOUT</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">CHECKOUT</li>
            </ol>
        </div>
    </nav>
</section>
<!--breadcrumb end-->


<!-- checkout  start -->
<section class="section-b-space common-bg">
    <ul class="common-decor">
        <li class="circel"></li>
        <li class="circel"></li>
        <li class="circel"></li>
        <li class="plus"></li>
        <li class="plus"></li>
    </ul>
    <div class="container">
        <div class="checkout-page">
            <div class="checkout-form">
                <form action='/billing2' method="POST">
                    <div class="row">
                        <div class="col-lg-6 col-sm-12 col-xs-12">
                            <div class="checkout-title">
                                <h3>Billing Details</h3>
                            </div> 
                            <div class="col-md-12">
                                        @if (Session::has('error'))
                                            <div class="alert alert-danger" role="alert">
                                            {{Session::get('error', 'Something went wrong. Please try again')}}
                                            </div>
                                            @elseif(Session::has('success'))
                                            <div class="alert alert-success" role="alert">
                                                {{Session::get('success')}}
                                            </div>
                                        @endif
                                    </div>
                            <div class="row check-out">
                            @csrf
                            <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <div class="field-label">First Name</div>
                                    <input type="text" name="firstname" value="" placeholder="">
                                </div>
                                <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <div class="field-label">Last Name</div>
                                    <input type="text" name="lastname" value="" placeholder="">
                                </div>
                                <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <div class="field-label">Email Address</div>
                                    <input type="text" name="email" value="" placeholder="">
                                </div>

                                <div class="form-group col-md-6 col-sm-6 col-xs-12">
                                    <div class="field-label">Phone</div>
                                    <input type="text" name="phone" value="" placeholder="">
                                </div>
                                
                                <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                    <div class="field-label">Country</div>
                                    <select name="country">
                                        <option value="india">India</option>
                                        <option value="SA">South Africa</option>
                                        <option value="USA">United State</option>
                                        <option  value="Australia">Australia</option>
                                        <option value="UK">United Kingdom</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                    <div class="field-label">Address</div>
                                    <input type="text" name="address" value="" placeholder="Street address">
                                </div>
                                <div class="form-group col-md-12 col-sm-12 col-xs-12">
                                    <div class="field-label">Town/City</div>
                                    <input type="text" name="town" value="" placeholder="">
                                </div>
                                
                                <div class="form-group col-md-12 col-sm-6 col-xs-12">
                                    <div class="field-label">Postal Code</div>
                                    <input type="text" name="postalcode" value="" placeholder="">
                                </div>
                                <div class="form-group col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <input type="checkbox" name="shipping-option" id="account-option"> &ensp;
                                    <label for="account-option">Create An Account?</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-sm-12 col-xs-12">
                            <div class="common-card">
                                <div class="order-box">
                                    <div class="title-box">
                                            @php $total = 0 @endphp

                                            @foreach((array) session('cart') as $id => $details)

                                                @php $total += $details['price'] * $details['quantity'] @endphp

                                            @endforeach
                                        <div>Product <span>Total</span></div>
                                    </div>
                                    <ul class="qty">
                                    @if(session('cart'))

                                        @foreach(session('cart') as $id => $details)    

                                             <li>{{ $details['name'] }} × {{ $details['quantity'] }} <span>&pound;{{ $details['price'] }}</span></li>


                                        @endforeach
                                    @endif
                                        <!-- <li>SLim Fit Jeans × 1 <span>$555.00</span></li> -->
                                    </ul>
                                    <ul class="sub-total">
                                        <li>Subtotal <span class="count">&pound;{{$total}}</span></li>
                                        <!-- <li>Shipping
                                            <div class="shipping">                                               
                                                <div class="shopping-option form-check">
                                                    <input class="form-check-input" type="checkbox" name="free-shipping" id="free-shipping">
                                                    <label class="form-check-label" for="free-shipping">Free Shipping</label>
                                                </div>
                                                <div class="shopping-option form-check">
                                                    <input class="form-check-input" type="checkbox" name="local-pickup" id="local-pickup">
                                                    <label class="form-check-label" for="local-pickup">Local Pickup</label>
                                                </div>
                                            </div>
                                        </li> -->
                                    </ul>
                                    <ul class="total">
                                        <li>Total <span class="count">&pound;{{$total}}</span></li>
                                    </ul>
                                </div>
                                <div class="payment-box">
                                    <div class="upper-box">
                                        <div class="payment-options">
                                            <ul>
                                                <li>
                                                    <div class="radio-option">
                                                        <input type="radio" name="payment-group" id="payment-1"
                                                               checked="checked">
                                                        <label for="payment-1">
                                                          Bank Payments
                                                          <span class="small-text">Please send a check to Store Name, Store Street, Store Town, Store State / County, Store Postcode.</span>
                                                        </label>
                                                    </div>

                                                </li>
                                                 <li>
                                                 <div>
                                                         
                                                          <span class="small-text">To place order, make payments to this account detail.</span>
</div>

                                                </li>
                                                <li>
                                                    <div>
                                                       
                                                           <p> Account Number: 26881561</p>
                                                           
                                                            <p>Sort code: 802260</p>
                                                            
                                                            <p>Kemzwigs Limited</p>
                                                        </div>
                                                </li>
                                              <!-- <li>
                                                    <div class="radio-option paypal">
                                                        <input type="radio" name="payment-group" id="payment-3">
                                                        <label for="payment-3">PayPal<span class="image"><img
                                                                src="../assets/images/paypal.png"
                                                                alt=""></span></label>
                                                    </div>
                                                </li>  -->
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="text-end">
                                    @if($total == 0)
                                        <a  href="/" class="btn_dark btn">Find Wigs</a>
                                    @else
                                        <button type="submit" class="btn btn_dark">
                                        Place Order
                                        </button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
<!-- checkout  end -->
<script>
    function placeorder(){

       // alert('here');
    }
</script>

@endsection