<!DOCTYPE html>
<html lang="en">
<head>
    <title>Kemzwigs</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
   
   
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="stylesheet" href="css/sweetalert2.min.css">
    <!--font-->
    <link href="https://fonts.googleapis.com/css?family=Work+Sans" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Prata" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Dancing+Script&display=swap" rel="stylesheet">
    <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" integrity="sha384-wvfXpqpZZVQGK6TAh5PVlGOfQNHSoD2xbE+QkPxCAFlNEevoEH3Sl0sibVcOQVnN" crossorigin="anonymous">

    <!--icon css-->
    <link rel="stylesheet" href="../assets/css/font-awesome.min.css">
    <link rel="stylesheet" href="../assets/css/themify-icons.css">

    <!--bootstrap css-->
    <link rel="stylesheet" href="../assets/css/bootstrap.css">

    <!--map css-->
    <link rel="stylesheet" href="../assets/css/vector-map.css">

    <!-- animate css -->
    <link rel="stylesheet" href="../assets/css/animate.css">

    <!--slick css-->
    <link rel="stylesheet" href="../assets/css/slick.css">
    <link rel="stylesheet" href="../assets/css/slick-theme.css">

    <!--theme css-->
    <link rel="stylesheet" href="../assets/css/style.css">

</head>
<body>

<!--loader start-->
<div class="loader-wrapper">
    <div></div>
    <div></div>
    <div></div>
</div>
<!--loader end-->

@include('includes.header')


@yield('content')

@include('includes.footer')



<!-- Quick-view modal popup start-->
<div class="modal fade bd-example-modal-lg theme-modal" id="quick-view" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content quick-view-modal">
            <div class="modal-body">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                </button>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 col-xs-12">
                            <div class="quick-view-img">
                                <img src="../assets/images/pro3/1.jpg" alt="" class="img-fluid blur-up lazyload">
                            </div>
                        </div>
                        <div class="col-lg-6 rtl-text">
                            <div class="product-right">
                                <h2>Women Pink Shirt</h2>
                                <h3>$32.96</h3>
                                <ul class="color-variant">
                                    <li class="bg-light0"></li>
                                    <li class="bg-light1"></li>
                                    <li class="bg-light2"></li>
                                </ul>
                                <div class="border-product">
                                    <h6 class="product-title">product details</h6>
                                    <p>Sed ut perspiciatis, unde omnis iste natus error sit voluptatem accusantium doloremque laudantium</p>
                                </div>
                                <div class="product-description border-product">
                                    <div class="size-box">
                                        <ul>
                                            <li class="active"><a href="javascript:void(0);">s</a></li>
                                            <li><a href="javascript:void(0);">m</a></li>
                                            <li><a href="javascript:void(0);">l</a></li>
                                            <li><a href="javascript:void(0);">xl</a></li>
                                        </ul>
                                    </div>
                                    <h6 class="product-title">quantity</h6>
                                    <div class="qty-box">
                                        <div class="input-group">
                                            <span class="input-group-prepend">
                                              <button type="button" class="btn quantity-left-minus" data-type="minus" data-field="">
                                                <i class="ti-minus"></i>
                                              </button> 
                                            </span>
                                            <input type="text" name="quantity" class="form-control input-number" value="1"> 
                                            <span class="input-group-prepend">
                                              <button type="button" class="btn quantity-right-plus" data-type="plus" data-field="">
                                                <i class="ti-plus"></i>
                                              </button>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="product-buttons">
                                    <a href="javascript:void(0);" class="btn btn_dark">
                                        add to cart
                                    </a> 
                                    <a href="javascript:void(0);" class="btn btn_dark">
                                    buy now</a></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Quick-view modal popup end-->


<!-- Add to cart panel start-->
<div id="cart_side" class="add_to_cart right">
    <a href="javascript:void(0)" class="overlay" onclick="closeCart()"></a>
    <div class="cart-inner">
        <div class="cart_top">
            <h3>my cart</h3>
            <div class="close-cart">
                <a href="javascript:void(0)" onclick="closeCart()">
                    <i class="fa fa-times" aria-hidden="true"></i>
                </a>
            </div>
        </div>
        @php $total = 0 @endphp

                        @foreach((array) session('cart') as $id => $details)

                            @php $total += $details['price'] * $details['quantity'] @endphp

                        @endforeach
        <div class="cart_media">
            <ul class="cart_product">
                
            @if(session('cart'))

                @foreach(session('cart') as $id => $details)
                    <li>
                        <div class="media">
                            <a href="javascript:void(0);">
                                <img alt="" class="me-3" src="{{ $details['image'] }}">
                            </a>
                            <div class="media-body">
                                <a href="javascript:void(0);">
                                     <h6>{{ $details['name'] }} </h6> 
                                </a>
                                <h4>
                                    <span>{{ $details['quantity'] }} x &pound; {{ $details['price'] }}</span>
                                </h4>
                            </div>
                        </div>
                        <div class="close-circle">
                            <a onclick="removeCart('{{ $details['id'] }}')" href="javascript:void(0);">
                                <i class="ti-trash" aria-hidden="true"></i>
                            </a>
                        </div>
                    </li>
                @endforeach
        @endif
                
            </ul>
            <ul class="cart_total">
                <li>
                    <div class="total">
                        <h5>subtotal : <span>&pound;{{$total }}</span></h5>
                    </div>
                </li>
                <li>
                    <div class="buttons">
                        <a href="/cart" class="btn btn-solid btn-xs view-cart">view cart</a>
                        <a  href="/checkout" class="btn btn-solid btn-xs checkout">checkout</a>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</div>
<!-- Add to cart panel end-->


<!-- Search top panel start-->
<div id="cart_top" class="add_to_cart top">
    <a href="javascript:void(0)" class="overlay" onclick="closeSearch()"></a>
    <div class="cart-inner top-search">
        <input type="search" placeholder="Search......Your Style...." name="search" class="searchbox-input"
               onkeyup="buttonUp();" required>
        <a href=""> <span class="ti-search" onclick="closeSearch()"></span></a>
    </div>
</div>
<!-- Search top panel end-->


<!-- tap to top start-->
<div class="tap-top top-cls">
    <div>
        <i class="fa fa-angle-double-up"></i>
    </div>
</div>
<!-- tap to top end-->


<!--letest jquary-->
<script src="../assets/js/jquery-3.4.0.js"></script>

<!--timer js-->
<script src="../assets/js/timer.js"></script>

<!--popper js-->
<script src="../assets/js/popper.min.js"></script>

<!--bootstrap js-->
<script src="../assets/js/bootstrap.js"></script>
<script src="../assets/js/bootstrap-notify.min.js"></script>

<!--slick js-->
<script src="../assets/js/slick.min.js"></script>

<!--menu js-->
<script src="../assets/js/menu.js"></script>

<!--theme js-->
<script src="../assets/js/script.js"></script>
<script src="sweetalert2.all.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
@yield('script')
<script>
    function about(){
        window.location.href ='/about';
    }
function openCartt() {
    document.getElementById("cart_side").classList.add('open-side');
}
function openCart(price, image, id, name) {

    
    var quantity = $('#quantity').val();
    crosssite();
    $.ajax({

            url: '{{ route('update.cart') }}',
            method: "patch",
            data: {
                _token: '{{ csrf_token() }}', 
                id: id, 
                quantity: quantity,
                price:price,
                image:image,
                name:name
            },
                
            success: function (response) {

            window.location.reload();
         

            }

            });
                document.getElementById("cart_side").classList.add('open-side');
}
function closeCart() {
    document.getElementById("cart_side").classList.remove('open-side');
}

function removeCart( id) {
  
    if(confirm("Are you sure want to remove?")) {

$.ajax({

    url: '{{ route('remove.from.cart') }}',

    method: "DELETE",

    data: {

        _token: '{{ csrf_token() }}', 

        id: id

    },

    success: function (response) {

        window.location.reload();
        
    }
   

});
document.getElementById("cart_side").classList.add('open-side');

}

}

function crosssite(){
  $.ajaxSetup({
	  // force ajax call on all browsers
				   cache: false,

				   // Enables cross domain requests
				   crossDomain: true,

				   // Helps in setting cookie
				   xhrFields: {
					   withCredentials: true
				   },

				   beforeSend: function (xhr, type) {
					   // Set the CSRF Token in the header for security
					   /*if (type.type !== "GET") {
						   var token = $('meta[name="csrf-token"]').attr('content');//Cookies.get("CSRF-TOKEN");
						   xhr.setRequestHeader('X-XSRF-Token', token);
					   }*/
				   }
	});}



    

</script>
</body>
</html>