

@extends('layouts.users')
@section('content')



<!--breadcrumb start-->
<section class="theme-breadcrumb">
    <nav aria-label="breadcrumb">
        <div>
            <h2 class="text-center">My Orders</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Orders</li>
            </ol>
        </div>
    </nav>
</section>
<!--breadcrumb end-->


<!--wishlist start-->
<section class="wishlist-section section-b-space common-bg">
    <ul class="common-decor">
        <li class="circel"></li>
        <li class="circel"></li>
        <li class="circel"></li>
        <li class="plus"></li>
        <li class="plus"></li>
    </ul>
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <table class="table cart-table table-responsive-xs">
                    <thead>
                    <tr class="table-head">
                        <th scope="col">Transaction ID</th>
                        <th scope="col">price</th>
                        <th scope="col">date</th>
                        <th scope="col">Payment Status</th>
                    </tr>
                    </thead>
                   
                    @foreach($billing as $m) 
                    <tbody>
                    <tr>
                        
                        <td><a href="javascript:void(0);">{{$m['trans_id']}}</a>
                        <div class="mobile-cart-content">
                            <div class="col-xs-3">
                                    <h5 class="td-color mb-0">&pound;{{$m['price']}}</h5>
                                </div>
                                <div class="col-xs-3">
                                    <h5 class="td-color mb-0">{{$m['created_at']}}</h5>
                                </div>
                                <div class="col-xs-3">
                                    <h2 class="td-color">
                                    @if($m['payment_status']==0)
                                    Payment Not Confirmed
                                    @endif
                                    @if($m['payment_status']==1)
                                    Payment Confirmed
                                    @endif
                        
                                        </h2>
                                </div>
                            </div>
                        </td>
                        <td>
                        &pound;{{$m['price']}}
                        </td>
                        <td>
                            <h5 class="mb-0">{{$m['created_at']}}</h5>
                        </td>
                       
                        <td>
                            @if($m['payment_status']==0)
                             Payment Not Confirmed
                            @endif
                            @if($m['payment_status']==1)
                             Payment Confirmed
                            @endif
                        </td>
                    </tr>
                    </tbody>

                    @endforeach
                    
                </table>
            </div>
        </div>

        <!-- <div class="row wishlist-buttons">
            <div class="col-12"><a href="javascript:void(0);" class="btn btn_dark">continue shopping</a> <a href="javascript:void(0);"
                                                                                          class="btn btn_dark mt-xs-2">check out</a></div>
        </div> -->
        {!! $billing->render() !!} 
    </div>
</section>
<!--section end-->
@endsection