<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
header('Access-Control-Allow-Credentials: true');

/*Route::get('/', function () {
    return view('index');key:generate
});*/

Route::get('/generate-key', function() {
    $exitCode = Artisan::call('key:generate');
    return '<h1>Key generated</h1>';
});
//Clear Cache facade value:
Route::get('/clear-cache', function() {
    $exitCode = Artisan::call('cache:clear');
    return '<h1>Cache facade value cleared</h1>';
});

//Reoptimized class loader:
Route::get('/optimize', function() {
    $exitCode = Artisan::call('optimize');
    return '<h1>Reoptimized class loader</h1>';
});

//Route cache:
Route::get('/route-cache', function() {
    $exitCode = Artisan::call('route:cache');
    return '<h1>Routes cached</h1>';
});

//Clear Route cache:
Route::get('/route-clear', function() {
    $exitCode = Artisan::call('route:clear');
    return '<h1>Route cache cleared</h1>';
});

//Clear View cache:
Route::get('/view-clear', function() {
    $exitCode = Artisan::call('view:clear');
    return '<h1>View cache cleared</h1>';
});

//Clear Config cache:
Route::get('/config-cache', function() {
    $exitCode = Artisan::call('config:cache');
    return '<h1>Clear Config cleared</h1>';
});

Route::get('/clear', function() {

   Artisan::call('cache:clear');
   Artisan::call('config:clear');
   Artisan::call('config:cache');
   Artisan::call('view:clear');

   return "Cleared!";

});


Route::get('/', [App\Http\Controllers\WelcomeController::class, 'welcome'])->name('welcome');
Route::get('/productdetails/{id}', [App\Http\Controllers\WelcomeController::class, 'productdetails'])->name('productdetails');
// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/about', function () {
    return view('about');
});

Route::get('/contact', function () {
    return view('contact');
});

Route::get('/faq', function () {
    return view('faq');
});

Route::get('/cart', function () {
    return view('cart');
});
// Route::get('/checkout', function () {
//     return view('checkout');
// });

Route::get('/requests', [App\Http\Controllers\ProductController::class, 'requests'])->name('requests');
Route::get('/viewrequest/{id}', [App\Http\Controllers\ProductController::class, 'viewrequest'])->name('viewrequest');
Route::post('/approverequest', [App\Http\Controllers\ProductController::class, 'approverequest'])->name('approverequest');


Route::get('/checkout', [App\Http\Controllers\ProductController::class, 'checkout'])->name('checkout');
Route::get('/myorders', [App\Http\Controllers\ProductController::class, 'myorders'])->name('myorders');

Route::post('/billing', [App\Http\Controllers\ProductController::class, 'billing'])->name('billing');
Route::post('/billing2', [App\Http\Controllers\ProductController::class, 'billing2'])->name('billing2');
// Route::get('/signin', function () {
//     return view('signin');
// });
Route::get('/signin', [App\Http\Controllers\HomeController::class, 'signin'])->name('signin');

Route::get('/signup', function () {
    return view('signup');
});
Auth::routes([
    'register' => false, // Registration Routes...
    'reset' => false, // Password Reset Routes...
    'verify' => false, // Email Verification Routes...
    'login' => false, // Email Verification Routes...
  ]);
// Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::post('/singup', [App\Http\Controllers\HomeController::class, 'singup'])->name('singup');
Route::post('/singing', [App\Http\Controllers\HomeController::class, 'singin'])->name('singin');
Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/changepassword', [App\Http\Controllers\HomeController::class, 'changepassword'])->name('changepassword');

Route::get('/ventures', [App\Http\Controllers\CategoryController::class, 'index'])->name('ventures'); //addproduct  removeccategory
Route::get('/createcategory', [App\Http\Controllers\CategoryController::class, 'createcategory'])->name('createcategory'); 
Route::post('/addcategory', [App\Http\Controllers\CategoryController::class, 'store'])->name('addcategory');
Route::get('/venturecategories', [App\Http\Controllers\HomeController::class, 'venturecategories'])->name('venturecategories');
Route::get('/products', [App\Http\Controllers\ProductController::class, 'show'])->name('products');
Route::get('/addproduct', [App\Http\Controllers\ProductController::class, 'addproduct'])->name('addproduct');
Route::post('/createvproducts', [App\Http\Controllers\ProductController::class, 'createvproducts'])->name('createproducts');
Route::post('/editvproducts', [App\Http\Controllers\ProductController::class, 'editvproducts'])->name('editvproducts');
Route::get('/editproduct/{id}', [App\Http\Controllers\ProductController::class, 'editproduct'])->name('editproduct');
Route::get('/removeproduct/{id}', [App\Http\Controllers\ProductController::class, 'removeproduct'])->name('removeproduct');
Route::get('/deactivateproduct/{id}', [App\Http\Controllers\ProductController::class, 'deactivateproduct'])->name('deactivateproduct');
Route::get('/activateproduct/{id}', [App\Http\Controllers\ProductController::class, 'activateproduct'])->name('deactivateproduct');
Route::get('/demandproduct/{id}', [App\Http\Controllers\HomeController::class, 'demandproduct'])->name('demandproduct');
Route::get('/logout', [App\Http\Controllers\HomeController::class,'logout']);
Route::get('/mailtestt', [App\Http\Controllers\HomeController::class,'mailtestt']);

Route::get('add-to-cart/{id}', [App\Http\Controllers\ProductController::class, 'addToCart'])->name('add.to.cart');

Route::patch('update-cart', [App\Http\Controllers\ProductController::class, 'update'])->name('update.cart');

Route::delete('remove-from-cart', [App\Http\Controllers\ProductController::class, 'remove'])->name('remove.from.cart');

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');




Route::get('/admin', [App\Http\Controllers\AdminController::class, 'index'])->name('admin');


